package demo.frame;

import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;

import com.sun.jna.Memory;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.IntByReference;

import demo.common.LocalData;
import demo.common.PaintPanel;
import demo.common.Res;
import demo.module.LoginModule;
import netsdk.lib.CommonFunctions;
import netsdk.lib.ErrorCodeAndConst;
import netsdk.struct.NET_SDK_IVE_FACE_MATCH_QUERY_ALBUM_INFO;
import netsdk.struct.NET_SDK_IVE_FACE_MATCH_QUERY_ALBUM_REPLY_INFO;
import netsdk.struct.intStruct;

import javax.swing.JTable;
import javax.swing.ListSelectionModel;

import java.awt.BorderLayout;

import javax.imageio.ImageIO;
import javax.swing.JButton;
import java.awt.event.ActionListener;
import java.util.Map;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;

public class IPCFaceManager extends JDialog{
	private JTable table;
	private Object[][] data;
	private DefaultTableModel defaultTableModel;
	private static PaintPanel pplFace;
	public IPCFaceManager() {
		setTitle("Face Manager");
	    setModal(true);  
	    //pack();
	    setSize(654, 503);
	    setResizable(false);
	    setLocationRelativeTo(null);  
	    setDefaultCloseOperation(DISPOSE_ON_CLOSE);   // 释放窗体
	    
		getContentPane().setLayout(null);
		
		
		data = new Object[10][3];
		String[] columnName = {"Index","ID","Name"};
		defaultTableModel = new DefaultTableModel(data, columnName);
		
		DefaultTableCellRenderer dCellRenderer = new DefaultTableCellRenderer();
		dCellRenderer.setHorizontalAlignment(JLabel.CENTER);

		//getContentPane().add(table);
		
		JButton btnQuery = new JButton("查询");
		btnQuery.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				NET_SDK_IVE_FACE_MATCH_QUERY_ALBUM_INFO pAlbumInfo = new NET_SDK_IVE_FACE_MATCH_QUERY_ALBUM_INFO();
                pAlbumInfo.iPageNum = 0;
                pAlbumInfo.iPageSize = 10;
//                pAlbumInfo.bUseTypeFilter = true;
//                pAlbumInfo.iType = 1;
                
                int tempSize = pAlbumInfo.size();
                Pointer pInputData = new Memory(tempSize);
                CommonFunctions.SetStructDataToPointer(pAlbumInfo,pInputData,0);
                IntByReference lpBytesReturned = new IntByReference();				
        		Pointer pOutputData = new Memory(1024*1024);
        		boolean bRet = LoginModule.netsdk.NET_SDK_FaceMatchOperate(LoginModule.m_hLoginHandle, 
        				ErrorCodeAndConst.NET_SDK_GET_FACE_IPC_LIST, 
        				pInputData, tempSize, pOutputData, 1024 * 1024, lpBytesReturned);
        		CommonFunctions.FreePointer(pInputData);//释放内存
        		if(bRet && lpBytesReturned.getValue() > 0) {
        			int offset = 0;
        			
        			int[] res = pOutputData.getIntArray(offset,2);
        			int totalNum = res[0];
        			int currentPageNum = res[1];
        			        			      			        			
        			offset += 2 * 4;
        			
    				NET_SDK_IVE_FACE_MATCH_QUERY_ALBUM_REPLY_INFO replyAlbum = 
    						new NET_SDK_IVE_FACE_MATCH_QUERY_ALBUM_REPLY_INFO(); 
    				if(currentPageNum > 0) {
    					LocalData.IPCFaceList.clear();
    				}
    				for(int i = 0;i< currentPageNum;i++) {
    					replyAlbum = new NET_SDK_IVE_FACE_MATCH_QUERY_ALBUM_REPLY_INFO();
    					CommonFunctions.GetPointerDataToStruct(pOutputData, offset, replyAlbum);
    					LocalData.IPCFaceList.put(i, replyAlbum);
    					offset += replyAlbum.size();
    					offset += replyAlbum.stBaseInfo.iPicSize;   					    					
    				}
    					      				
    				UpdateIPCFaceList();  			       			
        		}
        		CommonFunctions.FreePointer(pOutputData);//释放内存
			}
		});
		btnQuery.setBounds(29, 27, 93, 23);
		getContentPane().add(btnQuery);
		
		JButton btnAdd = new JButton("增加");
		btnAdd.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				AddModifyTarget amt = new  AddModifyTarget();
				
				amt.SetDialogName("Add Target");
//				amt.SetAlbum(albumInfo);
				amt.setVisible(true);
			}
		});
		btnAdd.setBounds(29, 71, 93, 23);
		getContentPane().add(btnAdd);
		
		JButton btnEdit = new JButton("修改");
		btnEdit.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				defaultTableModel = (DefaultTableModel)table.getModel();
				int row = table.getSelectedRow(); //获得所选的单行
				if(row < 0 || defaultTableModel.getValueAt(row, 0) == null) {
					return;
				}
				else {
					int index = (int) defaultTableModel.getValueAt(row, 0) - 1;
					NET_SDK_IVE_FACE_MATCH_QUERY_ALBUM_REPLY_INFO selectIPCFace = LocalData.IPCFaceList.get(index);
					
					AddModifyTarget amt = new  AddModifyTarget();
					
					amt.SetDialogName("Edit Target");
					amt.SetTarget(selectIPCFace);
					amt.setVisible(true);
				}
			}
		});
		btnEdit.setBounds(29, 116, 93, 23);
		getContentPane().add(btnEdit);
		
		JButton btnDel = new JButton("删除");
		btnDel.setBounds(29, 163, 93, 23);
		getContentPane().add(btnDel);
		table = new JTable(defaultTableModel) {   // 列表不可编辑
			private static final long serialVersionUID = 1L;
			@Override
			public boolean isCellEditable(int row, int column) {
				return false;
			}
		};
		table.addMouseListener(new MouseAdapter() {
			@Override
			public void mouseClicked(MouseEvent arg0) {
				if(arg0.getClickCount() == 2) {
					defaultTableModel = (DefaultTableModel)table.getModel();
					int row = table.getSelectedRow(); //获得所选的单行
					if(row < 0 || defaultTableModel.getValueAt(row, 0) == null) {
						return;
					}
					else {
						int index = (int) defaultTableModel.getValueAt(row, 0) - 1;
						NET_SDK_IVE_FACE_MATCH_QUERY_ALBUM_REPLY_INFO selectIPCFace = LocalData.IPCFaceList.get(index);
						
						NET_SDK_IVE_FACE_MATCH_QUERY_ALBUM_INFO pAlbumInfo = new NET_SDK_IVE_FACE_MATCH_QUERY_ALBUM_INFO();
		                pAlbumInfo.iPageNum = 0;
		                pAlbumInfo.iPageSize = 10;
		                
		                int tempSize = pAlbumInfo.size();
		                Pointer pInputData = new Memory(tempSize);
		                CommonFunctions.SetStructDataToPointer(pAlbumInfo,pInputData,0);
		                IntByReference lpBytesReturned = new IntByReference();				
		        		Pointer pOutputData = new Memory(1024*1024);
		        		boolean bRet = LoginModule.netsdk.NET_SDK_FaceMatchOperate(LoginModule.m_hLoginHandle, 
		        				ErrorCodeAndConst.NET_SDK_GET_FACE_IPC_LIST, 
		        				pInputData, tempSize, pOutputData, 1024 * 1024, lpBytesReturned);
		        		CommonFunctions.FreePointer(pInputData);//释放内存
		        		if(bRet && lpBytesReturned.getValue() > 0) {
		        			int offset = 0;
		        			
		        			int[] res = pOutputData.getIntArray(offset,2);
		        			int totalNum = res[0];
		        			int currentPageNum = res[1];
		        			        			      			        			
		        			offset += 2 * 4;
		        			
		    				NET_SDK_IVE_FACE_MATCH_QUERY_ALBUM_REPLY_INFO replyAlbum = 
		    						new NET_SDK_IVE_FACE_MATCH_QUERY_ALBUM_REPLY_INFO(); 		    				
		    				for(int i = 0;i< currentPageNum;i++) {
		    					replyAlbum = new NET_SDK_IVE_FACE_MATCH_QUERY_ALBUM_REPLY_INFO();
		    					CommonFunctions.GetPointerDataToStruct(pOutputData, offset, replyAlbum);
		    					if(replyAlbum.iKey == selectIPCFace.iKey) {
		    						offset += replyAlbum.size();
		    						byte[] picBytes = pOutputData.getByteArray(offset, replyAlbum.stBaseInfo.iPicSize);
		    						
		    						ByteArrayInputStream byteArr = new ByteArrayInputStream(picBytes);
		    		            	try {
		    		            		BufferedImage bImage = ImageIO.read(byteArr);		    							
		    		            		pplFace.setImage(bImage);
		    		            		pplFace.setOpaque(false); 
		    		            		pplFace.repaint();
		    							
		    						} catch (IOException e1) {
		    							// TODO Auto-generated catch block
		    							e1.printStackTrace();
		    						}
		    		            	break;
		    					}
		    					else {
		    						offset += replyAlbum.size();
			    					offset += replyAlbum.stBaseInfo.iPicSize;   
		    					}		    							    										    					
		    				}
		        		}
		        		CommonFunctions.FreePointer(pOutputData);//释放内存
					}
				}
			}
		});
		getContentPane().add(table);
	
		table.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);  // 只能选中一行
		table.setDefaultRenderer(Object.class, dCellRenderer);
		
		table.setBounds(172, 59, 208, 191);
		
		pplFace = new PaintPanel();
		pplFace.setBounds(422, 59, 198, 191);
		getContentPane().add(pplFace);
		
		JLabel lblNewLabel = new JLabel("目标列表");
		lblNewLabel.setBounds(241, 31, 54, 15);
		getContentPane().add(lblNewLabel);
	}
	public void UpdateIPCFaceList() {
		// 清空列表
		data = new Object[10][3];
		String[] columnName = {"Index","ID","Name"};
		table.setModel(new DefaultTableModel(data, columnName));
		//重新填入内容
		if(LocalData.IPCFaceList != null) {
			defaultTableModel = (DefaultTableModel)table.getModel();
			for(int i = 0; i < LocalData.IPCFaceList.size(); i++) {
				defaultTableModel.setValueAt(i+1, i, 0);
				defaultTableModel.setValueAt(LocalData.IPCFaceList.get(i).iKey, i, 1);
				String name = CommonFunctions.ByteToStr(LocalData.IPCFaceList.get(i).stBaseInfo.szName, "UTF8");
				defaultTableModel.setValueAt(String.valueOf(name), i, 2);
			}
		}
	}
}

